/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.IMobTargettingContext;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;

public class RemoveSpecificTasksProcessor
implements IMobSpawnProcessor {
    private final MobSpawnProcessorType<? extends RemoveSpecificTasksProcessor> type;
    private final String[] goalSelectorClasses;
    private final String[] targetSelectorClasses;

    public RemoveSpecificTasksProcessor(MobSpawnProcessorType<? extends RemoveSpecificTasksProcessor> type, String[] goalSelectorClasses, String[] targetSelectorClasses) {
        this.type = type;
        this.goalSelectorClasses = goalSelectorClasses;
        this.targetSelectorClasses = targetSelectorClasses;
    }

    @Override
    public MobSpawnProcessorType<?> getType() {
        return this.type;
    }

    @Override
    public void processMobSpawn(LivingEntity entity, IMobTargettingContext targettingContext) {
        if (!(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mob = (MobEntity)entity;
        List<Goal> goalsToRemove = this.findGoalsByClasses(mob.field_70714_bg, this.goalSelectorClasses);
        List<Goal> targetGoalsToRemove = this.findGoalsByClasses(mob.field_70715_bh, this.targetSelectorClasses);
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)mob.field_70714_bg).func_85156_a(arg_0));
        targetGoalsToRemove.forEach(arg_0 -> ((GoalSelector)mob.field_70715_bh).func_85156_a(arg_0));
    }

    private List<Goal> findGoalsByClasses(GoalSelector selector, String[] classes) {
        ArrayList<Goal> results = new ArrayList<Goal>();
        block0: for (PrioritizedGoal prioritizedGoal : selector.field_220892_d) {
            Goal goal = prioritizedGoal.func_220772_j();
            String name = goal.getClass().getName();
            for (String classpath : classes) {
                if (!name.equals(classpath)) continue;
                results.add(goal);
                continue block0;
            }
        }
        return results;
    }

    public static final class Serializer
    implements IMobSpawnProcessorSerializer<RemoveSpecificTasksProcessor> {
        @Override
        public RemoveSpecificTasksProcessor deserialize(MobSpawnProcessorType<RemoveSpecificTasksProcessor> type, JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            String[] goalClasses = Serializer.resolveArray(object, "goals");
            String[] targetGoalClasses = Serializer.resolveArray(object, "targetGoals");
            return new RemoveSpecificTasksProcessor(type, goalClasses, targetGoalClasses);
        }

        @Override
        public void toNbt(RemoveSpecificTasksProcessor processor, CompoundNBT nbt) {
            ListNBT goals = new ListNBT();
            Arrays.stream(processor.goalSelectorClasses).map(StringNBT::func_229705_a_).forEach(arg_0 -> goals.add(arg_0));
            ListNBT targetGoals = new ListNBT();
            Arrays.stream(processor.targetSelectorClasses).map(StringNBT::func_229705_a_).forEach(arg_0 -> targetGoals.add(arg_0));
            nbt.func_218657_a("goals", (INBT)goals);
            nbt.func_218657_a("targetGoals", (INBT)targetGoals);
        }

        @Override
        public RemoveSpecificTasksProcessor fromNbt(MobSpawnProcessorType<RemoveSpecificTasksProcessor> type, CompoundNBT nbt) {
            ListNBT goals = nbt.func_150295_c("goals", 8);
            ListNBT targetGoals = nbt.func_150295_c("targetGoals", 8);
            return new RemoveSpecificTasksProcessor(type, (String[])goals.stream().map(INBT::func_150285_a_).toArray(String[]::new), (String[])targetGoals.stream().map(INBT::func_150285_a_).toArray(String[]::new));
        }

        private static String[] resolveArray(JsonObject object, String key) {
            String[] array = new String[]{};
            if (object.has(key)) {
                JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)object, (String)key);
                array = JsonHelper.deserializeInto(jsonArray, String[]::new, JsonElement::getAsString);
            }
            return array;
        }
    }
}

